/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.blocks.wooden.WoodenBarrelBlockEntity;
import blusunrize.immersiveengineering.common.entities.IEMinecartEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.register.IEItems;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class BarrelMinecartEntity
extends IEMinecartEntity<WoodenBarrelBlockEntity> {
    public BarrelMinecartEntity(Level world, double x, double y, double z) {
        this((EntityType)IEEntityTypes.BARREL_MINECART.get(), world, x, y, z);
    }

    public BarrelMinecartEntity(EntityType<?> type, Level world, double x, double y, double z) {
        super(type, world, x, y, z);
    }

    public BarrelMinecartEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)IEItems.Minecarts.CART_WOODEN_BARREL.get());
    }

    @Override
    public void writeTileToItem(ItemStack itemStack) {
        CompoundTag tag = new CompoundTag();
        ((WoodenBarrelBlockEntity)this.containedBlockEntity).writeTank(tag, true);
        if (!tag.m_128456_()) {
            itemStack.m_41751_(tag);
        }
    }

    @Override
    public void readTileFromItem(LivingEntity placer, ItemStack itemStack) {
        ((WoodenBarrelBlockEntity)this.containedBlockEntity).readOnPlacement(placer, itemStack);
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (super.m_6096_(player, hand) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = player.m_21120_(hand);
        if (FluidUtil.getFluidHandler((ItemStack)itemstack).isPresent()) {
            ((WoodenBarrelBlockEntity)this.containedBlockEntity).interact(null, player, hand, itemstack, 0.0f, 0.0f, 0.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected Supplier<WoodenBarrelBlockEntity> getTileProvider() {
        return () -> new WoodenBarrelBlockEntity(BlockPos.f_121853_, IEBlocks.WoodenDevices.WOODEN_BARREL.defaultBlockState());
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.containedBlockEntity != null) {
            ((WoodenBarrelBlockEntity)this.containedBlockEntity).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).invalidate();
        }
    }

    public BlockState m_38178_() {
        return IEBlocks.WoodenDevices.WOODEN_BARREL.defaultBlockState();
    }
}

